package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ActivityType implements Enum {

    @JsonProperty("signin")
    SIGNIN("signin", "0"),

    @JsonProperty("user")
    USER("user", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2"),

    @JsonProperty("servicePrincipal")
    SERVICE_PRINCIPAL("servicePrincipal", "3");

    private final String name;
    private final String value;

    private ActivityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
