package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AccessReviewHistoryDecisionFilter implements Enum {

    @JsonProperty("approve")
    APPROVE("approve", "0"),

    @JsonProperty("deny")
    DENY("deny", "1"),

    @JsonProperty("notReviewed")
    NOT_REVIEWED("notReviewed", "2"),

    @JsonProperty("dontKnow")
    DONT_KNOW("dontKnow", "3"),

    @JsonProperty("notNotified")
    NOT_NOTIFIED("notNotified", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private AccessReviewHistoryDecisionFilter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
