package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AccessPackageCustomExtensionStage implements Enum {

    @JsonProperty("assignmentRequestCreated")
    ASSIGNMENT_REQUEST_CREATED("assignmentRequestCreated", "1"),

    @JsonProperty("assignmentRequestApproved")
    ASSIGNMENT_REQUEST_APPROVED("assignmentRequestApproved", "2"),

    @JsonProperty("assignmentRequestGranted")
    ASSIGNMENT_REQUEST_GRANTED("assignmentRequestGranted", "3"),

    @JsonProperty("assignmentRequestRemoved")
    ASSIGNMENT_REQUEST_REMOVED("assignmentRequestRemoved", "4"),

    @JsonProperty("assignmentFourteenDaysBeforeExpiration")
    ASSIGNMENT_FOURTEEN_DAYS_BEFORE_EXPIRATION("assignmentFourteenDaysBeforeExpiration", "5"),

    @JsonProperty("assignmentOneDayBeforeExpiration")
    ASSIGNMENT_ONE_DAY_BEFORE_EXPIRATION("assignmentOneDayBeforeExpiration", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private AccessPackageCustomExtensionStage(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
