package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AccessLevel implements Enum {

    @JsonProperty("everyone")
    EVERYONE("everyone", "0"),

    @JsonProperty("invited")
    INVITED("invited", "1"),

    @JsonProperty("locked")
    LOCKED("locked", "2"),

    @JsonProperty("sameEnterprise")
    SAME_ENTERPRISE("sameEnterprise", "3"),

    @JsonProperty("sameEnterpriseAndFederated")
    SAME_ENTERPRISE_AND_FEDERATED("sameEnterpriseAndFederated", "4");

    private final String name;
    private final String value;

    private AccessLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
