package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookRange;
import odata.msgraph.client.beta.entity.WorkbookRangeView;
import odata.msgraph.client.beta.entity.collection.request.WorkbookRangeViewCollectionRequest;

@JsonIgnoreType
public class WorkbookRangeViewRequest extends EntityRequest<WorkbookRangeView> {

    public WorkbookRangeViewRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookRangeView.class, contextPath, value, false);
    }

    public WorkbookRangeViewRequest rows(String id) {
        return new WorkbookRangeViewRequest(contextPath.addSegment("rows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookRangeViewCollectionRequest rows() {
        return new WorkbookRangeViewCollectionRequest(
                        contextPath.addSegment("rows"), Optional.empty());
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

}
