package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.WorkbookSortField;
import odata.msgraph.client.beta.entity.WorkbookRangeSort;

@JsonIgnoreType
public class WorkbookRangeSortRequest extends EntityRequest<WorkbookRangeSort> {

    public WorkbookRangeSortRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookRangeSort.class, contextPath, value, false);
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestNoReturn apply(List<WorkbookSortField> fields, Boolean matchCase, Boolean hasHeaders, String orientation, String method) {
        Preconditions.checkNotNull(matchCase, "matchCase cannot be null");
        Preconditions.checkNotNull(hasHeaders, "hasHeaders cannot be null");
        Preconditions.checkNotNull(orientation, "orientation cannot be null");
        Preconditions.checkNotNull(method, "method cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fields", "Collection(microsoft.graph.workbookSortField)", fields)
            .put("matchCase", "Edm.Boolean", matchCase)
            .put("hasHeaders", "Edm.Boolean", hasHeaders)
            .put("orientation", "Edm.String", Checks.checkIsAscii(orientation))
            .put("method", "Edm.String", Checks.checkIsAscii(method))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.apply"), _parameters);
    }

}
