package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.WorkbookFunctionResult;
import odata.msgraph.client.beta.entity.WorkbookFunctions;

@JsonIgnoreType
public class WorkbookFunctionsRequest extends EntityRequest<WorkbookFunctions> {

    public WorkbookFunctionsRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookFunctions.class, contextPath, value, false);
    }

    @Action(name = "delta")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> delta(Json number1, Json number2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number1", "microsoft.graph.Json", number1)
            .put("number2", "microsoft.graph.Json", number2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "lookup")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> lookup(Json lookupValue, Json lookupVector, Json resultVector) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("lookupValue", "microsoft.graph.Json", lookupValue)
            .put("lookupVector", "microsoft.graph.Json", lookupVector)
            .put("resultVector", "microsoft.graph.Json", resultVector)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lookup"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "abs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> abs(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.abs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "accrInt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> accrInt(Json issue, Json firstInterest, Json settlement, Json rate, Json par, Json frequency, Json basis, Json calcMethod) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("issue", "microsoft.graph.Json", issue)
            .put("firstInterest", "microsoft.graph.Json", firstInterest)
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("rate", "microsoft.graph.Json", rate)
            .put("par", "microsoft.graph.Json", par)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .put("calcMethod", "microsoft.graph.Json", calcMethod)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accrInt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "accrIntM")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> accrIntM(Json issue, Json settlement, Json rate, Json par, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("issue", "microsoft.graph.Json", issue)
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("rate", "microsoft.graph.Json", rate)
            .put("par", "microsoft.graph.Json", par)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accrIntM"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "acos")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> acos(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acos"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "acosh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> acosh(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acosh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "acot")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> acot(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acot"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "acoth")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> acoth(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acoth"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "amorDegrc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> amorDegrc(Json cost, Json datePurchased, Json firstPeriod, Json salvage, Json period, Json rate, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("datePurchased", "microsoft.graph.Json", datePurchased)
            .put("firstPeriod", "microsoft.graph.Json", firstPeriod)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("period", "microsoft.graph.Json", period)
            .put("rate", "microsoft.graph.Json", rate)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.amorDegrc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "amorLinc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> amorLinc(Json cost, Json datePurchased, Json firstPeriod, Json salvage, Json period, Json rate, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("datePurchased", "microsoft.graph.Json", datePurchased)
            .put("firstPeriod", "microsoft.graph.Json", firstPeriod)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("period", "microsoft.graph.Json", period)
            .put("rate", "microsoft.graph.Json", rate)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.amorLinc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "and")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> and(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.and"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "arabic")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> arabic(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.arabic"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "areas")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> areas(Json reference) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reference", "microsoft.graph.Json", reference)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.areas"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "asc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> asc(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.asc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "asin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> asin(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.asin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "asinh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> asinh(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.asinh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "atan")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> atan(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.atan"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "atan2")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> atan2(Json xNum, Json yNum) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("xNum", "microsoft.graph.Json", xNum)
            .put("yNum", "microsoft.graph.Json", yNum)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.atan2"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "atanh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> atanh(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.atanh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "aveDev")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> aveDev(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.aveDev"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "average")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> average(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.average"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "averageA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> averageA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.averageA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "averageIf")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> averageIf(Json range, Json criteria, Json averageRange) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("range", "microsoft.graph.Json", range)
            .put("criteria", "microsoft.graph.Json", criteria)
            .put("averageRange", "microsoft.graph.Json", averageRange)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.averageIf"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "averageIfs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> averageIfs(Json averageRange, Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("averageRange", "microsoft.graph.Json", averageRange)
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.averageIfs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bahtText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bahtText(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bahtText"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "base")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> base(Json number, Json radix, Json minLength) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("radix", "microsoft.graph.Json", radix)
            .put("minLength", "microsoft.graph.Json", minLength)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.base"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "besselI")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> besselI(Json x, Json n) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("n", "microsoft.graph.Json", n)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.besselI"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "besselJ")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> besselJ(Json x, Json n) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("n", "microsoft.graph.Json", n)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.besselJ"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "besselK")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> besselK(Json x, Json n) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("n", "microsoft.graph.Json", n)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.besselK"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "besselY")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> besselY(Json x, Json n) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("n", "microsoft.graph.Json", n)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.besselY"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "beta_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> beta_Dist(Json x, Json alpha, Json beta, Json cumulative, Json A, Json B) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("beta", "microsoft.graph.Json", beta)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .put("A", "microsoft.graph.Json", A)
            .put("B", "microsoft.graph.Json", B)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.beta_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "beta_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> beta_Inv(Json probability, Json alpha, Json beta, Json A, Json B) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("beta", "microsoft.graph.Json", beta)
            .put("A", "microsoft.graph.Json", A)
            .put("B", "microsoft.graph.Json", B)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.beta_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bin2Dec")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bin2Dec(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bin2Dec"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bin2Hex")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bin2Hex(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bin2Hex"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bin2Oct")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bin2Oct(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bin2Oct"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "binom_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> binom_Dist(Json numberS, Json trials, Json probabilityS, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("numberS", "microsoft.graph.Json", numberS)
            .put("trials", "microsoft.graph.Json", trials)
            .put("probabilityS", "microsoft.graph.Json", probabilityS)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.binom_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "binom_Dist_Range")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> binom_Dist_Range(Json trials, Json probabilityS, Json numberS, Json numberS2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("trials", "microsoft.graph.Json", trials)
            .put("probabilityS", "microsoft.graph.Json", probabilityS)
            .put("numberS", "microsoft.graph.Json", numberS)
            .put("numberS2", "microsoft.graph.Json", numberS2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.binom_Dist_Range"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "binom_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> binom_Inv(Json trials, Json probabilityS, Json alpha) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("trials", "microsoft.graph.Json", trials)
            .put("probabilityS", "microsoft.graph.Json", probabilityS)
            .put("alpha", "microsoft.graph.Json", alpha)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.binom_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bitand")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bitand(Json number1, Json number2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number1", "microsoft.graph.Json", number1)
            .put("number2", "microsoft.graph.Json", number2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bitand"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bitlshift")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bitlshift(Json number, Json shiftAmount) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("shiftAmount", "microsoft.graph.Json", shiftAmount)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bitlshift"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bitor")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bitor(Json number1, Json number2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number1", "microsoft.graph.Json", number1)
            .put("number2", "microsoft.graph.Json", number2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bitor"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bitrshift")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bitrshift(Json number, Json shiftAmount) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("shiftAmount", "microsoft.graph.Json", shiftAmount)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bitrshift"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "bitxor")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> bitxor(Json number1, Json number2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number1", "microsoft.graph.Json", number1)
            .put("number2", "microsoft.graph.Json", number2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bitxor"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ceiling_Math")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ceiling_Math(Json number, Json significance, Json mode) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("significance", "microsoft.graph.Json", significance)
            .put("mode", "microsoft.graph.Json", mode)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ceiling_Math"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ceiling_Precise")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ceiling_Precise(Json number, Json significance) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("significance", "microsoft.graph.Json", significance)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ceiling_Precise"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "char")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> char_(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.char"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "chiSq_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> chiSq_Dist(Json x, Json degFreedom, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.chiSq_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "chiSq_Dist_RT")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> chiSq_Dist_RT(Json x, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.chiSq_Dist_RT"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "chiSq_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> chiSq_Inv(Json probability, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.chiSq_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "chiSq_Inv_RT")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> chiSq_Inv_RT(Json probability, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.chiSq_Inv_RT"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "choose")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> choose(Json indexNum, Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("indexNum", "microsoft.graph.Json", indexNum)
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.choose"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "clean")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> clean(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clean"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "code")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> code(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.code"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "columns")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> columns(Json array) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.columns"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "combin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> combin(Json number, Json numberChosen) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numberChosen", "microsoft.graph.Json", numberChosen)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.combin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "combina")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> combina(Json number, Json numberChosen) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numberChosen", "microsoft.graph.Json", numberChosen)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.combina"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "complex")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> complex(Json realNum, Json iNum, Json suffix) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("realNum", "microsoft.graph.Json", realNum)
            .put("iNum", "microsoft.graph.Json", iNum)
            .put("suffix", "microsoft.graph.Json", suffix)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.complex"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "concatenate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> concatenate(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.concatenate"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "confidence_Norm")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> confidence_Norm(Json alpha, Json standardDev, Json size) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .put("size", "microsoft.graph.Json", size)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.confidence_Norm"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "confidence_T")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> confidence_T(Json alpha, Json standardDev, Json size) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .put("size", "microsoft.graph.Json", size)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.confidence_T"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "convert")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> convert(Json number, Json fromUnit, Json toUnit) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("fromUnit", "microsoft.graph.Json", fromUnit)
            .put("toUnit", "microsoft.graph.Json", toUnit)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.convert"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "cos")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> cos(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cos"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "cosh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> cosh(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cosh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "cot")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> cot(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cot"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coth")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coth(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coth"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "count")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> count(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "countA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> countA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.countA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "countBlank")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> countBlank(Json range) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("range", "microsoft.graph.Json", range)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.countBlank"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "countIf")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> countIf(Json range, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("range", "microsoft.graph.Json", range)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.countIf"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "countIfs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> countIfs(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.countIfs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coupDayBs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coupDayBs(Json settlement, Json maturity, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coupDayBs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coupDays")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coupDays(Json settlement, Json maturity, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coupDays"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coupDaysNc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coupDaysNc(Json settlement, Json maturity, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coupDaysNc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coupNcd")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coupNcd(Json settlement, Json maturity, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coupNcd"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coupNum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coupNum(Json settlement, Json maturity, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coupNum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "coupPcd")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> coupPcd(Json settlement, Json maturity, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.coupPcd"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "csc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> csc(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.csc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "csch")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> csch(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.csch"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "cumIPmt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> cumIPmt(Json rate, Json nper, Json pv, Json startPeriod, Json endPeriod, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .put("startPeriod", "microsoft.graph.Json", startPeriod)
            .put("endPeriod", "microsoft.graph.Json", endPeriod)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cumIPmt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "cumPrinc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> cumPrinc(Json rate, Json nper, Json pv, Json startPeriod, Json endPeriod, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .put("startPeriod", "microsoft.graph.Json", startPeriod)
            .put("endPeriod", "microsoft.graph.Json", endPeriod)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cumPrinc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "date")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> date(Json year, Json month, Json day) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("year", "microsoft.graph.Json", year)
            .put("month", "microsoft.graph.Json", month)
            .put("day", "microsoft.graph.Json", day)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.date"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "datevalue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> datevalue(Json dateText) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("dateText", "microsoft.graph.Json", dateText)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.datevalue"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "daverage")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> daverage(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.daverage"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "day")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> day(Json serialNumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.day"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "days")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> days(Json endDate, Json startDate) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("endDate", "microsoft.graph.Json", endDate)
            .put("startDate", "microsoft.graph.Json", startDate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.days"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "days360")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> days360(Json startDate, Json endDate, Json method) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("endDate", "microsoft.graph.Json", endDate)
            .put("method", "microsoft.graph.Json", method)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.days360"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "db")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> db(Json cost, Json salvage, Json life, Json period, Json month) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("life", "microsoft.graph.Json", life)
            .put("period", "microsoft.graph.Json", period)
            .put("month", "microsoft.graph.Json", month)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.db"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dbcs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dbcs(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dbcs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dcount")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dcount(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dcount"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dcountA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dcountA(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dcountA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ddb")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ddb(Json cost, Json salvage, Json life, Json period, Json factor) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("life", "microsoft.graph.Json", life)
            .put("period", "microsoft.graph.Json", period)
            .put("factor", "microsoft.graph.Json", factor)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ddb"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dec2Bin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dec2Bin(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dec2Bin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dec2Hex")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dec2Hex(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dec2Hex"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dec2Oct")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dec2Oct(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dec2Oct"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "decimal")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> decimal(Json number, Json radix) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("radix", "microsoft.graph.Json", radix)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decimal"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "degrees")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> degrees(Json angle) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("angle", "microsoft.graph.Json", angle)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.degrees"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "devSq")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> devSq(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.devSq"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dget")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dget(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dget"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "disc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> disc(Json settlement, Json maturity, Json pr, Json redemption, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("pr", "microsoft.graph.Json", pr)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dmax")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dmax(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dmax"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dmin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dmin(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dmin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dollar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dollar(Json number, Json decimals) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("decimals", "microsoft.graph.Json", decimals)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dollar"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dollarDe")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dollarDe(Json fractionalDollar, Json fraction) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fractionalDollar", "microsoft.graph.Json", fractionalDollar)
            .put("fraction", "microsoft.graph.Json", fraction)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dollarDe"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dollarFr")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dollarFr(Json decimalDollar, Json fraction) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("decimalDollar", "microsoft.graph.Json", decimalDollar)
            .put("fraction", "microsoft.graph.Json", fraction)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dollarFr"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dproduct")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dproduct(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dproduct"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dstDev")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dstDev(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dstDev"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dstDevP")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dstDevP(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dstDevP"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dsum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dsum(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dsum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "duration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> duration(Json settlement, Json maturity, Json coupon, Json yld, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("coupon", "microsoft.graph.Json", coupon)
            .put("yld", "microsoft.graph.Json", yld)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.duration"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dvar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dvar(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dvar"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "dvarP")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> dvarP(Json database, Json field, Json criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("database", "microsoft.graph.Json", database)
            .put("field", "microsoft.graph.Json", field)
            .put("criteria", "microsoft.graph.Json", criteria)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dvarP"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ecma_Ceiling")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ecma_Ceiling(Json number, Json significance) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("significance", "microsoft.graph.Json", significance)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ecma_Ceiling"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "edate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> edate(Json startDate, Json months) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("months", "microsoft.graph.Json", months)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.edate"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "effect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> effect(Json nominalRate, Json npery) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("nominalRate", "microsoft.graph.Json", nominalRate)
            .put("npery", "microsoft.graph.Json", npery)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.effect"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "eoMonth")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> eoMonth(Json startDate, Json months) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("months", "microsoft.graph.Json", months)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.eoMonth"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "erf")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> erf(Json lowerLimit, Json upperLimit) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("lowerLimit", "microsoft.graph.Json", lowerLimit)
            .put("upperLimit", "microsoft.graph.Json", upperLimit)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.erf"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "erfC")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> erfC(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.erfC"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "erfC_Precise")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> erfC_Precise(Json X) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("X", "microsoft.graph.Json", X)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.erfC_Precise"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "erf_Precise")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> erf_Precise(Json X) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("X", "microsoft.graph.Json", X)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.erf_Precise"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "error_Type")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> error_Type(Json errorVal) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("errorVal", "microsoft.graph.Json", errorVal)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.error_Type"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "even")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> even(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.even"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "exact")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> exact(Json text1, Json text2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text1", "microsoft.graph.Json", text1)
            .put("text2", "microsoft.graph.Json", text2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exact"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "exp")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> exp(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exp"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "expon_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> expon_Dist(Json x, Json lambda, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("lambda", "microsoft.graph.Json", lambda)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.expon_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "fact")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> fact(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.fact"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "factDouble")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> factDouble(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.factDouble"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "false")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> false_() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.false"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "find")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> find(Json findText, Json withinText, Json startNum) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("findText", "microsoft.graph.Json", findText)
            .put("withinText", "microsoft.graph.Json", withinText)
            .put("startNum", "microsoft.graph.Json", startNum)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.find"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "findB")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> findB(Json findText, Json withinText, Json startNum) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("findText", "microsoft.graph.Json", findText)
            .put("withinText", "microsoft.graph.Json", withinText)
            .put("startNum", "microsoft.graph.Json", startNum)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findB"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "fisher")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> fisher(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.fisher"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "fisherInv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> fisherInv(Json y) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("y", "microsoft.graph.Json", y)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.fisherInv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "fixed")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> fixed(Json number, Json decimals, Json noCommas) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("decimals", "microsoft.graph.Json", decimals)
            .put("noCommas", "microsoft.graph.Json", noCommas)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.fixed"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "floor_Math")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> floor_Math(Json number, Json significance, Json mode) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("significance", "microsoft.graph.Json", significance)
            .put("mode", "microsoft.graph.Json", mode)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.floor_Math"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "floor_Precise")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> floor_Precise(Json number, Json significance) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("significance", "microsoft.graph.Json", significance)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.floor_Precise"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "fv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> fv(Json rate, Json nper, Json pmt, Json pv, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pmt", "microsoft.graph.Json", pmt)
            .put("pv", "microsoft.graph.Json", pv)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.fv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "fvschedule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> fvschedule(Json principal, Json schedule) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("principal", "microsoft.graph.Json", principal)
            .put("schedule", "microsoft.graph.Json", schedule)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.fvschedule"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "f_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> f_Dist(Json x, Json degFreedom1, Json degFreedom2, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom1", "microsoft.graph.Json", degFreedom1)
            .put("degFreedom2", "microsoft.graph.Json", degFreedom2)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.f_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "f_Dist_RT")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> f_Dist_RT(Json x, Json degFreedom1, Json degFreedom2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom1", "microsoft.graph.Json", degFreedom1)
            .put("degFreedom2", "microsoft.graph.Json", degFreedom2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.f_Dist_RT"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "f_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> f_Inv(Json probability, Json degFreedom1, Json degFreedom2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("degFreedom1", "microsoft.graph.Json", degFreedom1)
            .put("degFreedom2", "microsoft.graph.Json", degFreedom2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.f_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "f_Inv_RT")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> f_Inv_RT(Json probability, Json degFreedom1, Json degFreedom2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("degFreedom1", "microsoft.graph.Json", degFreedom1)
            .put("degFreedom2", "microsoft.graph.Json", degFreedom2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.f_Inv_RT"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gamma")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gamma(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gamma"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gammaLn")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gammaLn(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gammaLn"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gammaLn_Precise")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gammaLn_Precise(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gammaLn_Precise"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gamma_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gamma_Dist(Json x, Json alpha, Json beta, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("beta", "microsoft.graph.Json", beta)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gamma_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gamma_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gamma_Inv(Json probability, Json alpha, Json beta) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("beta", "microsoft.graph.Json", beta)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gamma_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gauss")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gauss(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gauss"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "gcd")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> gcd(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.gcd"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "geoMean")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> geoMean(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.geoMean"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "geStep")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> geStep(Json number, Json step) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("step", "microsoft.graph.Json", step)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.geStep"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "harMean")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> harMean(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.harMean"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hex2Bin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hex2Bin(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hex2Bin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hex2Dec")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hex2Dec(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hex2Dec"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hex2Oct")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hex2Oct(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hex2Oct"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hlookup")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hlookup(Json lookupValue, Json tableArray, Json rowIndexNum, Json rangeLookup) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("lookupValue", "microsoft.graph.Json", lookupValue)
            .put("tableArray", "microsoft.graph.Json", tableArray)
            .put("rowIndexNum", "microsoft.graph.Json", rowIndexNum)
            .put("rangeLookup", "microsoft.graph.Json", rangeLookup)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hlookup"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hour")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hour(Json serialNumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hour"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hyperlink")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hyperlink(Json linkLocation, Json friendlyName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("linkLocation", "microsoft.graph.Json", linkLocation)
            .put("friendlyName", "microsoft.graph.Json", friendlyName)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hyperlink"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "hypGeom_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> hypGeom_Dist(Json sampleS, Json numberSample, Json populationS, Json numberPop, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sampleS", "microsoft.graph.Json", sampleS)
            .put("numberSample", "microsoft.graph.Json", numberSample)
            .put("populationS", "microsoft.graph.Json", populationS)
            .put("numberPop", "microsoft.graph.Json", numberPop)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hypGeom_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "if")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> if_(Json logicalTest, Json valueIfTrue, Json valueIfFalse) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("logicalTest", "microsoft.graph.Json", logicalTest)
            .put("valueIfTrue", "microsoft.graph.Json", valueIfTrue)
            .put("valueIfFalse", "microsoft.graph.Json", valueIfFalse)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.if"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imAbs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imAbs(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imAbs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imaginary")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imaginary(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imaginary"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imArgument")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imArgument(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imArgument"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imConjugate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imConjugate(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imConjugate"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imCos")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imCos(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imCos"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imCosh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imCosh(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imCosh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imCot")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imCot(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imCot"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imCsc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imCsc(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imCsc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imCsch")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imCsch(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imCsch"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imDiv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imDiv(Json inumber1, Json inumber2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber1", "microsoft.graph.Json", inumber1)
            .put("inumber2", "microsoft.graph.Json", inumber2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imDiv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imExp")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imExp(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imExp"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imLn")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imLn(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imLn"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imLog10")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imLog10(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imLog10"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imLog2")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imLog2(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imLog2"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imPower")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imPower(Json inumber, Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imPower"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imProduct")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imProduct(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imProduct"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imReal")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imReal(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imReal"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSec")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSec(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSec"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSech")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSech(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSech"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSin(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSinh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSinh(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSinh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSqrt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSqrt(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSqrt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSub")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSub(Json inumber1, Json inumber2) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber1", "microsoft.graph.Json", inumber1)
            .put("inumber2", "microsoft.graph.Json", inumber2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSub"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imSum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imSum(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imSum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "imTan")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> imTan(Json inumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("inumber", "microsoft.graph.Json", inumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.imTan"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "int")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> int_(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.int"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "intRate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> intRate(Json settlement, Json maturity, Json investment, Json redemption, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("investment", "microsoft.graph.Json", investment)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.intRate"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ipmt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ipmt(Json rate, Json per, Json nper, Json pv, Json fv, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("per", "microsoft.graph.Json", per)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ipmt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "irr")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> irr(Json values, Json guess) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .put("guess", "microsoft.graph.Json", guess)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.irr"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isErr")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isErr(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isErr"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isError")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isError(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isError"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isEven")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isEven(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isEven"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isFormula")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isFormula(Json reference) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reference", "microsoft.graph.Json", reference)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isFormula"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isLogical")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isLogical(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isLogical"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isNA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isNA(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isNA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isNonText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isNonText(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isNonText"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isNumber")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isNumber(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isNumber"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isOdd")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isOdd(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isOdd"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isoWeekNum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isoWeekNum(Json date) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "microsoft.graph.Json", date)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isoWeekNum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "iso_Ceiling")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> iso_Ceiling(Json number, Json significance) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("significance", "microsoft.graph.Json", significance)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.iso_Ceiling"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ispmt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ispmt(Json rate, Json per, Json nper, Json pv) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("per", "microsoft.graph.Json", per)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ispmt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isref")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isref(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isref"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "isText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> isText(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isText"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "kurt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> kurt(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.kurt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "large")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> large(Json array, Json k) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("k", "microsoft.graph.Json", k)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.large"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "lcm")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> lcm(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lcm"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "left")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> left(Json text, Json numChars) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("numChars", "microsoft.graph.Json", numChars)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.left"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "leftb")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> leftb(Json text, Json numBytes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("numBytes", "microsoft.graph.Json", numBytes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.leftb"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "len")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> len(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.len"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "lenb")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> lenb(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lenb"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ln")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ln(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ln"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "log")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> log(Json number, Json base) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("base", "microsoft.graph.Json", base)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.log"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "log10")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> log10(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.log10"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "logNorm_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> logNorm_Dist(Json x, Json mean, Json standardDev, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("mean", "microsoft.graph.Json", mean)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logNorm_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "logNorm_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> logNorm_Inv(Json probability, Json mean, Json standardDev) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("mean", "microsoft.graph.Json", mean)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logNorm_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "lower")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> lower(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lower"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "match")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> match(Json lookupValue, Json lookupArray, Json matchType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("lookupValue", "microsoft.graph.Json", lookupValue)
            .put("lookupArray", "microsoft.graph.Json", lookupArray)
            .put("matchType", "microsoft.graph.Json", matchType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.match"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "max")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> max(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.max"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "maxA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> maxA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.maxA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "mduration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> mduration(Json settlement, Json maturity, Json coupon, Json yld, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("coupon", "microsoft.graph.Json", coupon)
            .put("yld", "microsoft.graph.Json", yld)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mduration"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "median")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> median(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.median"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "mid")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> mid(Json text, Json startNum, Json numChars) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("startNum", "microsoft.graph.Json", startNum)
            .put("numChars", "microsoft.graph.Json", numChars)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mid"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "midb")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> midb(Json text, Json startNum, Json numBytes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("startNum", "microsoft.graph.Json", startNum)
            .put("numBytes", "microsoft.graph.Json", numBytes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.midb"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "min")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> min(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.min"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "minA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> minA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.minA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "minute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> minute(Json serialNumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.minute"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "mirr")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> mirr(Json values, Json financeRate, Json reinvestRate) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .put("financeRate", "microsoft.graph.Json", financeRate)
            .put("reinvestRate", "microsoft.graph.Json", reinvestRate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mirr"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "mod")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> mod(Json number, Json divisor) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("divisor", "microsoft.graph.Json", divisor)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mod"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "month")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> month(Json serialNumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.month"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "mround")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> mround(Json number, Json multiple) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("multiple", "microsoft.graph.Json", multiple)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mround"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "multiNomial")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> multiNomial(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.multiNomial"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "n")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> n(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.n"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "na")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> na() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.na"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "negBinom_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> negBinom_Dist(Json numberF, Json numberS, Json probabilityS, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("numberF", "microsoft.graph.Json", numberF)
            .put("numberS", "microsoft.graph.Json", numberS)
            .put("probabilityS", "microsoft.graph.Json", probabilityS)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.negBinom_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "networkDays")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> networkDays(Json startDate, Json endDate, Json holidays) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("endDate", "microsoft.graph.Json", endDate)
            .put("holidays", "microsoft.graph.Json", holidays)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.networkDays"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "networkDays_Intl")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> networkDays_Intl(Json startDate, Json endDate, Json weekend, Json holidays) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("endDate", "microsoft.graph.Json", endDate)
            .put("weekend", "microsoft.graph.Json", weekend)
            .put("holidays", "microsoft.graph.Json", holidays)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.networkDays_Intl"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "nominal")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> nominal(Json effectRate, Json npery) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("effectRate", "microsoft.graph.Json", effectRate)
            .put("npery", "microsoft.graph.Json", npery)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.nominal"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "norm_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> norm_Dist(Json x, Json mean, Json standardDev, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("mean", "microsoft.graph.Json", mean)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.norm_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "norm_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> norm_Inv(Json probability, Json mean, Json standardDev) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("mean", "microsoft.graph.Json", mean)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.norm_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "norm_S_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> norm_S_Dist(Json z, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("z", "microsoft.graph.Json", z)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.norm_S_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "norm_S_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> norm_S_Inv(Json probability) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.norm_S_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "not")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> not(Json logical) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("logical", "microsoft.graph.Json", logical)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.not"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "now")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> now() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.now"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "nper")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> nper(Json rate, Json pmt, Json pv, Json fv, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("pmt", "microsoft.graph.Json", pmt)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.nper"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "npv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> npv(Json rate, Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.npv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "numberValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> numberValue(Json text, Json decimalSeparator, Json groupSeparator) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("decimalSeparator", "microsoft.graph.Json", decimalSeparator)
            .put("groupSeparator", "microsoft.graph.Json", groupSeparator)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.numberValue"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oct2Bin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oct2Bin(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oct2Bin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oct2Dec")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oct2Dec(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oct2Dec"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oct2Hex")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oct2Hex(Json number, Json places) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("places", "microsoft.graph.Json", places)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oct2Hex"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "odd")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> odd(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.odd"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oddFPrice")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oddFPrice(Json settlement, Json maturity, Json issue, Json firstCoupon, Json rate, Json yld, Json redemption, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("issue", "microsoft.graph.Json", issue)
            .put("firstCoupon", "microsoft.graph.Json", firstCoupon)
            .put("rate", "microsoft.graph.Json", rate)
            .put("yld", "microsoft.graph.Json", yld)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oddFPrice"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oddFYield")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oddFYield(Json settlement, Json maturity, Json issue, Json firstCoupon, Json rate, Json pr, Json redemption, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("issue", "microsoft.graph.Json", issue)
            .put("firstCoupon", "microsoft.graph.Json", firstCoupon)
            .put("rate", "microsoft.graph.Json", rate)
            .put("pr", "microsoft.graph.Json", pr)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oddFYield"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oddLPrice")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oddLPrice(Json settlement, Json maturity, Json lastInterest, Json rate, Json yld, Json redemption, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("lastInterest", "microsoft.graph.Json", lastInterest)
            .put("rate", "microsoft.graph.Json", rate)
            .put("yld", "microsoft.graph.Json", yld)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oddLPrice"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "oddLYield")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> oddLYield(Json settlement, Json maturity, Json lastInterest, Json rate, Json pr, Json redemption, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("lastInterest", "microsoft.graph.Json", lastInterest)
            .put("rate", "microsoft.graph.Json", rate)
            .put("pr", "microsoft.graph.Json", pr)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.oddLYield"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "or")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> or(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.or"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "pduration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> pduration(Json rate, Json pv, Json fv) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pduration"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "percentile_Exc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> percentile_Exc(Json array, Json k) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("k", "microsoft.graph.Json", k)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.percentile_Exc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "percentile_Inc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> percentile_Inc(Json array, Json k) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("k", "microsoft.graph.Json", k)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.percentile_Inc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "percentRank_Exc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> percentRank_Exc(Json array, Json x, Json significance) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("x", "microsoft.graph.Json", x)
            .put("significance", "microsoft.graph.Json", significance)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.percentRank_Exc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "percentRank_Inc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> percentRank_Inc(Json array, Json x, Json significance) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("x", "microsoft.graph.Json", x)
            .put("significance", "microsoft.graph.Json", significance)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.percentRank_Inc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "permut")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> permut(Json number, Json numberChosen) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numberChosen", "microsoft.graph.Json", numberChosen)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.permut"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "permutationa")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> permutationa(Json number, Json numberChosen) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numberChosen", "microsoft.graph.Json", numberChosen)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.permutationa"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "phi")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> phi(Json x) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.phi"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "pi")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> pi() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pi"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "pmt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> pmt(Json rate, Json nper, Json pv, Json fv, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pmt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "poisson_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> poisson_Dist(Json x, Json mean, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("mean", "microsoft.graph.Json", mean)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.poisson_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "power")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> power(Json number, Json power) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("power", "microsoft.graph.Json", power)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.power"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "ppmt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> ppmt(Json rate, Json per, Json nper, Json pv, Json fv, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("per", "microsoft.graph.Json", per)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ppmt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "price")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> price(Json settlement, Json maturity, Json rate, Json yld, Json redemption, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("rate", "microsoft.graph.Json", rate)
            .put("yld", "microsoft.graph.Json", yld)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.price"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "priceDisc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> priceDisc(Json settlement, Json maturity, Json discount, Json redemption, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("discount", "microsoft.graph.Json", discount)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.priceDisc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "priceMat")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> priceMat(Json settlement, Json maturity, Json issue, Json rate, Json yld, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("issue", "microsoft.graph.Json", issue)
            .put("rate", "microsoft.graph.Json", rate)
            .put("yld", "microsoft.graph.Json", yld)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.priceMat"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "product")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> product(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.product"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "proper")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> proper(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.proper"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "pv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> pv(Json rate, Json nper, Json pmt, Json fv, Json type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("nper", "microsoft.graph.Json", nper)
            .put("pmt", "microsoft.graph.Json", pmt)
            .put("fv", "microsoft.graph.Json", fv)
            .put("type", "microsoft.graph.Json", type)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "quartile_Exc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> quartile_Exc(Json array, Json quart) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("quart", "microsoft.graph.Json", quart)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.quartile_Exc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "quartile_Inc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> quartile_Inc(Json array, Json quart) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("quart", "microsoft.graph.Json", quart)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.quartile_Inc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "quotient")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> quotient(Json numerator, Json denominator) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("numerator", "microsoft.graph.Json", numerator)
            .put("denominator", "microsoft.graph.Json", denominator)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.quotient"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "radians")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> radians(Json angle) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("angle", "microsoft.graph.Json", angle)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.radians"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rand")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rand() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rand"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "randBetween")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> randBetween(Json bottom, Json top) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("bottom", "microsoft.graph.Json", bottom)
            .put("top", "microsoft.graph.Json", top)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.randBetween"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rank_Avg")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rank_Avg(Json number, Json ref, Json order) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("ref", "microsoft.graph.Json", ref)
            .put("order", "microsoft.graph.Json", order)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rank_Avg"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rank_Eq")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rank_Eq(Json number, Json ref, Json order) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("ref", "microsoft.graph.Json", ref)
            .put("order", "microsoft.graph.Json", order)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rank_Eq"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rate(Json nper, Json pmt, Json pv, Json fv, Json type, Json guess) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("nper", "microsoft.graph.Json", nper)
            .put("pmt", "microsoft.graph.Json", pmt)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .put("type", "microsoft.graph.Json", type)
            .put("guess", "microsoft.graph.Json", guess)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rate"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "received")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> received(Json settlement, Json maturity, Json investment, Json discount, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("investment", "microsoft.graph.Json", investment)
            .put("discount", "microsoft.graph.Json", discount)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.received"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "replace")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> replace(Json oldText, Json startNum, Json numChars, Json newText) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("oldText", "microsoft.graph.Json", oldText)
            .put("startNum", "microsoft.graph.Json", startNum)
            .put("numChars", "microsoft.graph.Json", numChars)
            .put("newText", "microsoft.graph.Json", newText)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.replace"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "replaceB")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> replaceB(Json oldText, Json startNum, Json numBytes, Json newText) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("oldText", "microsoft.graph.Json", oldText)
            .put("startNum", "microsoft.graph.Json", startNum)
            .put("numBytes", "microsoft.graph.Json", numBytes)
            .put("newText", "microsoft.graph.Json", newText)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.replaceB"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rept")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rept(Json text, Json numberTimes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("numberTimes", "microsoft.graph.Json", numberTimes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rept"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "right")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> right(Json text, Json numChars) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("numChars", "microsoft.graph.Json", numChars)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.right"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rightb")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rightb(Json text, Json numBytes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("numBytes", "microsoft.graph.Json", numBytes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rightb"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "roman")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> roman(Json number, Json form) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("form", "microsoft.graph.Json", form)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roman"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "round")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> round(Json number, Json numDigits) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numDigits", "microsoft.graph.Json", numDigits)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.round"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "roundDown")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> roundDown(Json number, Json numDigits) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numDigits", "microsoft.graph.Json", numDigits)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roundDown"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "roundUp")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> roundUp(Json number, Json numDigits) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numDigits", "microsoft.graph.Json", numDigits)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roundUp"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rows")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rows(Json array) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rows"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "rri")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> rri(Json nper, Json pv, Json fv) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("nper", "microsoft.graph.Json", nper)
            .put("pv", "microsoft.graph.Json", pv)
            .put("fv", "microsoft.graph.Json", fv)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rri"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sec")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sec(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sec"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sech")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sech(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sech"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "second")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> second(Json serialNumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.second"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "seriesSum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> seriesSum(Json x, Json n, Json m, Json coefficients) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("n", "microsoft.graph.Json", n)
            .put("m", "microsoft.graph.Json", m)
            .put("coefficients", "microsoft.graph.Json", coefficients)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.seriesSum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sheet")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sheet(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sheet"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sheets")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sheets(Json reference) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reference", "microsoft.graph.Json", reference)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sheets"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sign")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sign(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sign"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sin(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sin"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sinh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sinh(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sinh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "skew")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> skew(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.skew"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "skew_p")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> skew_p(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.skew_p"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sln")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sln(Json cost, Json salvage, Json life) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("life", "microsoft.graph.Json", life)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sln"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "small")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> small(Json array, Json k) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("k", "microsoft.graph.Json", k)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.small"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sqrt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sqrt(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sqrt"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sqrtPi")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sqrtPi(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sqrtPi"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "standardize")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> standardize(Json x, Json mean, Json standardDev) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("mean", "microsoft.graph.Json", mean)
            .put("standardDev", "microsoft.graph.Json", standardDev)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.standardize"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "stDevA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> stDevA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stDevA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "stDevPA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> stDevPA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stDevPA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "stDev_P")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> stDev_P(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stDev_P"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "stDev_S")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> stDev_S(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stDev_S"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "substitute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> substitute(Json text, Json oldText, Json newText, Json instanceNum) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .put("oldText", "microsoft.graph.Json", oldText)
            .put("newText", "microsoft.graph.Json", newText)
            .put("instanceNum", "microsoft.graph.Json", instanceNum)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.substitute"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "subtotal")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> subtotal(Json functionNum, Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("functionNum", "microsoft.graph.Json", functionNum)
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.subtotal"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sum(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sumIf")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sumIf(Json range, Json criteria, Json sumRange) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("range", "microsoft.graph.Json", range)
            .put("criteria", "microsoft.graph.Json", criteria)
            .put("sumRange", "microsoft.graph.Json", sumRange)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sumIf"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sumIfs")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sumIfs(Json sumRange, Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sumRange", "microsoft.graph.Json", sumRange)
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sumIfs"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "sumSq")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> sumSq(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sumSq"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "syd")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> syd(Json cost, Json salvage, Json life, Json per) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("life", "microsoft.graph.Json", life)
            .put("per", "microsoft.graph.Json", per)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syd"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "t")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> t(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.t"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "tan")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> tan(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tan"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "tanh")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> tanh(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tanh"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "tbillEq")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> tbillEq(Json settlement, Json maturity, Json discount) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("discount", "microsoft.graph.Json", discount)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tbillEq"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "tbillPrice")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> tbillPrice(Json settlement, Json maturity, Json discount) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("discount", "microsoft.graph.Json", discount)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tbillPrice"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "tbillYield")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> tbillYield(Json settlement, Json maturity, Json pr) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("pr", "microsoft.graph.Json", pr)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tbillYield"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "text")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> text(Json value, Json formatText) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .put("formatText", "microsoft.graph.Json", formatText)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.text"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "time")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> time(Json hour, Json minute, Json second) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hour", "microsoft.graph.Json", hour)
            .put("minute", "microsoft.graph.Json", minute)
            .put("second", "microsoft.graph.Json", second)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.time"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "timevalue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> timevalue(Json timeText) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("timeText", "microsoft.graph.Json", timeText)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.timevalue"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "today")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> today() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.today"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "trim")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> trim(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.trim"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "trimMean")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> trimMean(Json array, Json percent) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("percent", "microsoft.graph.Json", percent)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.trimMean"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "true")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> true_() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.true"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "trunc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> trunc(Json number, Json numDigits) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("numDigits", "microsoft.graph.Json", numDigits)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.trunc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "type")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> type(Json value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "microsoft.graph.Json", value)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.type"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "t_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> t_Dist(Json x, Json degFreedom, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.t_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "t_Dist_2T")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> t_Dist_2T(Json x, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.t_Dist_2T"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "t_Dist_RT")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> t_Dist_RT(Json x, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.t_Dist_RT"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "t_Inv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> t_Inv(Json probability, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.t_Inv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "t_Inv_2T")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> t_Inv_2T(Json probability, Json degFreedom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("probability", "microsoft.graph.Json", probability)
            .put("degFreedom", "microsoft.graph.Json", degFreedom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.t_Inv_2T"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "unichar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> unichar(Json number) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unichar"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "unicode")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> unicode(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unicode"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "upper")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> upper(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.upper"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "usdollar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> usdollar(Json number, Json decimals) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("number", "microsoft.graph.Json", number)
            .put("decimals", "microsoft.graph.Json", decimals)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usdollar"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "value")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> value(Json text) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "microsoft.graph.Json", text)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.value"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "varA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> varA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.varA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "varPA")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> varPA(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.varPA"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "var_P")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> var_P(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.var_P"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "var_S")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> var_S(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.var_S"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "vdb")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> vdb(Json cost, Json salvage, Json life, Json startPeriod, Json endPeriod, Json factor, Json noSwitch) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cost", "microsoft.graph.Json", cost)
            .put("salvage", "microsoft.graph.Json", salvage)
            .put("life", "microsoft.graph.Json", life)
            .put("startPeriod", "microsoft.graph.Json", startPeriod)
            .put("endPeriod", "microsoft.graph.Json", endPeriod)
            .put("factor", "microsoft.graph.Json", factor)
            .put("noSwitch", "microsoft.graph.Json", noSwitch)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.vdb"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "vlookup")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> vlookup(Json lookupValue, Json tableArray, Json colIndexNum, Json rangeLookup) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("lookupValue", "microsoft.graph.Json", lookupValue)
            .put("tableArray", "microsoft.graph.Json", tableArray)
            .put("colIndexNum", "microsoft.graph.Json", colIndexNum)
            .put("rangeLookup", "microsoft.graph.Json", rangeLookup)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.vlookup"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "weekday")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> weekday(Json serialNumber, Json returnType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .put("returnType", "microsoft.graph.Json", returnType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.weekday"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "weekNum")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> weekNum(Json serialNumber, Json returnType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .put("returnType", "microsoft.graph.Json", returnType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.weekNum"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "weibull_Dist")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> weibull_Dist(Json x, Json alpha, Json beta, Json cumulative) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("x", "microsoft.graph.Json", x)
            .put("alpha", "microsoft.graph.Json", alpha)
            .put("beta", "microsoft.graph.Json", beta)
            .put("cumulative", "microsoft.graph.Json", cumulative)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.weibull_Dist"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "workDay")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> workDay(Json startDate, Json days, Json holidays) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("days", "microsoft.graph.Json", days)
            .put("holidays", "microsoft.graph.Json", holidays)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.workDay"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "workDay_Intl")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> workDay_Intl(Json startDate, Json days, Json weekend, Json holidays) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("days", "microsoft.graph.Json", days)
            .put("weekend", "microsoft.graph.Json", weekend)
            .put("holidays", "microsoft.graph.Json", holidays)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.workDay_Intl"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "xirr")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> xirr(Json values, Json dates, Json guess) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .put("dates", "microsoft.graph.Json", dates)
            .put("guess", "microsoft.graph.Json", guess)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.xirr"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "xnpv")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> xnpv(Json rate, Json values, Json dates) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("rate", "microsoft.graph.Json", rate)
            .put("values", "microsoft.graph.Json", values)
            .put("dates", "microsoft.graph.Json", dates)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.xnpv"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "xor")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> xor(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.xor"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "year")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> year(Json serialNumber) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("serialNumber", "microsoft.graph.Json", serialNumber)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.year"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "yearFrac")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> yearFrac(Json startDate, Json endDate, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDate", "microsoft.graph.Json", startDate)
            .put("endDate", "microsoft.graph.Json", endDate)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.yearFrac"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "yield")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> yield(Json settlement, Json maturity, Json rate, Json pr, Json redemption, Json frequency, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("rate", "microsoft.graph.Json", rate)
            .put("pr", "microsoft.graph.Json", pr)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("frequency", "microsoft.graph.Json", frequency)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.yield"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "yieldDisc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> yieldDisc(Json settlement, Json maturity, Json pr, Json redemption, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("pr", "microsoft.graph.Json", pr)
            .put("redemption", "microsoft.graph.Json", redemption)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.yieldDisc"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "yieldMat")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> yieldMat(Json settlement, Json maturity, Json issue, Json rate, Json pr, Json basis) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settlement", "microsoft.graph.Json", settlement)
            .put("maturity", "microsoft.graph.Json", maturity)
            .put("issue", "microsoft.graph.Json", issue)
            .put("rate", "microsoft.graph.Json", rate)
            .put("pr", "microsoft.graph.Json", pr)
            .put("basis", "microsoft.graph.Json", basis)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.yieldMat"), WorkbookFunctionResult.class, _parameters);
    }

    @Action(name = "z_Test")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult> z_Test(Json array, Json x, Json sigma) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("array", "microsoft.graph.Json", array)
            .put("x", "microsoft.graph.Json", x)
            .put("sigma", "microsoft.graph.Json", sigma)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookFunctionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.z_Test"), WorkbookFunctionResult.class, _parameters);
    }

}
