package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartSeries;
import odata.msgraph.client.beta.entity.collection.request.WorkbookChartPointCollectionRequest;

@JsonIgnoreType
public class WorkbookChartSeriesRequest extends EntityRequest<WorkbookChartSeries> {

    public WorkbookChartSeriesRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookChartSeries.class, contextPath, value, false);
    }

    public WorkbookChartSeriesFormatRequest format() {
        return new WorkbookChartSeriesFormatRequest(contextPath.addSegment("format"), Optional.empty());
    }

    public WorkbookChartPointRequest points(String id) {
        return new WorkbookChartPointRequest(contextPath.addSegment("points").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookChartPointCollectionRequest points() {
        return new WorkbookChartPointCollectionRequest(
                        contextPath.addSegment("points"), Optional.empty());
    }

}
