package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartAxes;

@JsonIgnoreType
public class WorkbookChartAxesRequest extends EntityRequest<WorkbookChartAxes> {

    public WorkbookChartAxesRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookChartAxes.class, contextPath, value, false);
    }

    public WorkbookChartAxisRequest categoryAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("categoryAxis"), Optional.empty());
    }

    public WorkbookChartAxisRequest seriesAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("seriesAxis"), Optional.empty());
    }

    public WorkbookChartAxisRequest valueAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("valueAxis"), Optional.empty());
    }

}
