package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsWifiEnterpriseEAPConfiguration;
import odata.msgraph.client.beta.entity.collection.request.Windows81TrustedRootCertificateCollectionRequest;

@JsonIgnoreType
public class WindowsWifiEnterpriseEAPConfigurationRequest extends EntityRequest<WindowsWifiEnterpriseEAPConfiguration> {

    public WindowsWifiEnterpriseEAPConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsWifiEnterpriseEAPConfiguration.class, contextPath, value, false);
    }

    public WindowsCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new WindowsCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public Windows81TrustedRootCertificateRequest rootCertificateForClientValidation() {
        return new Windows81TrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForClientValidation"), Optional.empty());
    }

    public Windows81TrustedRootCertificateRequest rootCertificatesForServerValidation(String id) {
        return new Windows81TrustedRootCertificateRequest(contextPath.addSegment("rootCertificatesForServerValidation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Windows81TrustedRootCertificateCollectionRequest rootCertificatesForServerValidation() {
        return new Windows81TrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"), Optional.empty());
    }

}
