package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsUniversalAppX;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;

@JsonIgnoreType
public class WindowsUniversalAppXRequest extends EntityRequest<WindowsUniversalAppX> {

    public WindowsUniversalAppXRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsUniversalAppX.class, contextPath, value, false);
    }

    public MobileContainedAppRequest committedContainedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("committedContainedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileContainedAppCollectionRequest committedContainedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("committedContainedApps"), Optional.empty());
    }

}
