package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsMalwareInformation;
import odata.msgraph.client.beta.entity.collection.request.MalwareStateForWindowsDeviceCollectionRequest;

@JsonIgnoreType
public class WindowsMalwareInformationRequest extends EntityRequest<WindowsMalwareInformation> {

    public WindowsMalwareInformationRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsMalwareInformation.class, contextPath, value, false);
    }

    public MalwareStateForWindowsDeviceRequest deviceMalwareStates(String id) {
        return new MalwareStateForWindowsDeviceRequest(contextPath.addSegment("deviceMalwareStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MalwareStateForWindowsDeviceCollectionRequest deviceMalwareStates() {
        return new MalwareStateForWindowsDeviceCollectionRequest(
                        contextPath.addSegment("deviceMalwareStates"), Optional.empty());
    }

}
