package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BulkDriverActionResult;
import odata.msgraph.client.beta.entity.WindowsDriverUpdateProfile;
import odata.msgraph.client.beta.entity.WindowsDriverUpdateProfileAssignment;
import odata.msgraph.client.beta.entity.collection.request.WindowsDriverUpdateInventoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDriverUpdateProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.enums.DriverApprovalAction;

@JsonIgnoreType
public class WindowsDriverUpdateProfileRequest extends EntityRequest<WindowsDriverUpdateProfile> {

    public WindowsDriverUpdateProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsDriverUpdateProfile.class, contextPath, value, false);
    }

    public WindowsDriverUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsDriverUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDriverUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsDriverUpdateProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public WindowsDriverUpdateInventoryRequest driverInventories(String id) {
        return new WindowsDriverUpdateInventoryRequest(contextPath.addSegment("driverInventories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDriverUpdateInventoryCollectionRequest driverInventories() {
        return new WindowsDriverUpdateInventoryCollectionRequest(
                        contextPath.addSegment("driverInventories"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsDriverUpdateProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.windowsDriverUpdateProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "executeAction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkDriverActionResult> executeAction(DriverApprovalAction actionName, List<String> driverIds, OffsetDateTime deploymentDate) {
        Preconditions.checkNotNull(actionName, "actionName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("actionName", "microsoft.graph.driverApprovalAction", actionName)
            .put("driverIds", "Collection(Edm.String)", Checks.checkIsAscii(driverIds))
            .put("deploymentDate", "Edm.DateTimeOffset", deploymentDate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkDriverActionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.executeAction"), BulkDriverActionResult.class, _parameters);
    }

    @Action(name = "syncInventory")
    @JsonIgnore
    public ActionRequestNoReturn syncInventory() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncInventory"), _parameters);
    }

}
