package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsDomainJoinConfiguration;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;

@JsonIgnoreType
public class WindowsDomainJoinConfigurationRequest extends EntityRequest<WindowsDomainJoinConfiguration> {

    public WindowsDomainJoinConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsDomainJoinConfiguration.class, contextPath, value, false);
    }

    public DeviceConfigurationRequest networkAccessConfigurations(String id) {
        return new DeviceConfigurationRequest(contextPath.addSegment("networkAccessConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationCollectionRequest networkAccessConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("networkAccessConfigurations"), Optional.empty());
    }

}
