package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsAutopilotDeviceIdentity;

@JsonIgnoreType
public class WindowsAutopilotDeviceIdentityRequest extends EntityRequest<WindowsAutopilotDeviceIdentity> {

    public WindowsAutopilotDeviceIdentityRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsAutopilotDeviceIdentity.class, contextPath, value, false);
    }

    public WindowsAutopilotDeploymentProfileRequest deploymentProfile() {
        return new WindowsAutopilotDeploymentProfileRequest(contextPath.addSegment("deploymentProfile"), Optional.empty());
    }

    public WindowsAutopilotDeploymentProfileRequest intendedDeploymentProfile() {
        return new WindowsAutopilotDeploymentProfileRequest(contextPath.addSegment("intendedDeploymentProfile"), Optional.empty());
    }

    @Action(name = "assignResourceAccountToDevice")
    @JsonIgnore
    public ActionRequestNoReturn assignResourceAccountToDevice(String userPrincipalName, String addressableUserName, String resourceAccountName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("addressableUserName", "Edm.String", Checks.checkIsAscii(addressableUserName))
            .put("resourceAccountName", "Edm.String", Checks.checkIsAscii(resourceAccountName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignResourceAccountToDevice"), _parameters);
    }

    @Action(name = "assignUserToDevice")
    @JsonIgnore
    public ActionRequestNoReturn assignUserToDevice(String userPrincipalName, String addressableUserName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("addressableUserName", "Edm.String", Checks.checkIsAscii(addressableUserName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignUserToDevice"), _parameters);
    }

    @Action(name = "unassignResourceAccountFromDevice")
    @JsonIgnore
    public ActionRequestNoReturn unassignResourceAccountFromDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unassignResourceAccountFromDevice"), _parameters);
    }

    @Action(name = "unassignUserFromDevice")
    @JsonIgnore
    public ActionRequestNoReturn unassignUserFromDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unassignUserFromDevice"), _parameters);
    }

    @Action(name = "updateDeviceProperties")
    @JsonIgnore
    public ActionRequestNoReturn updateDeviceProperties(String userPrincipalName, String addressableUserName, String groupTag, String displayName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("addressableUserName", "Edm.String", Checks.checkIsAscii(addressableUserName))
            .put("groupTag", "Edm.String", Checks.checkIsAscii(groupTag))
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateDeviceProperties"), _parameters);
    }

}
