package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Windows10GeneralConfiguration;
import odata.msgraph.client.beta.entity.collection.request.WindowsPrivacyDataAccessControlItemCollectionRequest;

@JsonIgnoreType
public class Windows10GeneralConfigurationRequest extends EntityRequest<Windows10GeneralConfiguration> {

    public Windows10GeneralConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Windows10GeneralConfiguration.class, contextPath, value, false);
    }

    public WindowsPrivacyDataAccessControlItemRequest privacyAccessControls(String id) {
        return new WindowsPrivacyDataAccessControlItemRequest(contextPath.addSegment("privacyAccessControls").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsPrivacyDataAccessControlItemCollectionRequest privacyAccessControls() {
        return new WindowsPrivacyDataAccessControlItemCollectionRequest(
                        contextPath.addSegment("privacyAccessControls"), Optional.empty());
    }

}
