package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserSettings;

@JsonIgnoreType
public class UserSettingsRequest extends EntityRequest<UserSettings> {

    public UserSettingsRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserSettings.class, contextPath, value, false);
    }

    public UserInsightsSettingsRequest itemInsights() {
        return new UserInsightsSettingsRequest(contextPath.addSegment("itemInsights"), Optional.empty());
    }

    public ContactMergeSuggestionsRequest contactMergeSuggestions() {
        return new ContactMergeSuggestionsRequest(contextPath.addSegment("contactMergeSuggestions"), Optional.empty());
    }

    public RegionalAndLanguageSettingsRequest regionalAndLanguageSettings() {
        return new RegionalAndLanguageSettingsRequest(contextPath.addSegment("regionalAndLanguageSettings"), Optional.empty());
    }

    public ShiftPreferencesRequest shiftPreferences() {
        return new ShiftPreferencesRequest(contextPath.addSegment("shiftPreferences"), Optional.empty());
    }

}
