package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserInstallStateSummary;
import odata.msgraph.client.beta.entity.collection.request.DeviceInstallStateCollectionRequest;

@JsonIgnoreType
public class UserInstallStateSummaryRequest extends EntityRequest<UserInstallStateSummary> {

    public UserInstallStateSummaryRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserInstallStateSummary.class, contextPath, value, false);
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.empty());
    }

}
