package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsRegressionSummary;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricCollectionRequest;
import odata.msgraph.client.beta.enums.UserExperienceAnalyticsSummarizedBy;

@JsonIgnoreType
public class UserExperienceAnalyticsRegressionSummaryRequest extends EntityRequest<UserExperienceAnalyticsRegressionSummary> {

    public UserExperienceAnalyticsRegressionSummaryRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserExperienceAnalyticsRegressionSummary.class, contextPath, value, false);
    }

    public UserExperienceAnalyticsMetricRequest manufacturerRegression(String id) {
        return new UserExperienceAnalyticsMetricRequest(contextPath.addSegment("manufacturerRegression").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsMetricCollectionRequest manufacturerRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("manufacturerRegression"), Optional.empty());
    }

    public UserExperienceAnalyticsMetricRequest modelRegression(String id) {
        return new UserExperienceAnalyticsMetricRequest(contextPath.addSegment("modelRegression").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsMetricCollectionRequest modelRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("modelRegression"), Optional.empty());
    }

    public UserExperienceAnalyticsMetricRequest operatingSystemRegression(String id) {
        return new UserExperienceAnalyticsMetricRequest(contextPath.addSegment("operatingSystemRegression").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsMetricCollectionRequest operatingSystemRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("operatingSystemRegression"), Optional.empty());
    }

    @Function(name = "summarizeDeviceRegressionPerformance")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsRegressionSummary> summarizeDeviceRegressionPerformance(UserExperienceAnalyticsSummarizedBy summarizeBy) {
        Preconditions.checkNotNull(summarizeBy, "summarizeBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("summarizeBy", "microsoft.graph.userExperienceAnalyticsSummarizedBy", summarizeBy)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsRegressionSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.summarizeDeviceRegressionPerformance"), UserExperienceAnalyticsRegressionSummary.class, _parameters);
    }

}
