package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsBaseline;

@JsonIgnoreType
public class UserExperienceAnalyticsBaselineRequest extends EntityRequest<UserExperienceAnalyticsBaseline> {

    public UserExperienceAnalyticsBaselineRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserExperienceAnalyticsBaseline.class, contextPath, value, false);
    }

    public UserExperienceAnalyticsCategoryRequest appHealthMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("appHealthMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest batteryHealthMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("batteryHealthMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest bestPracticesMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("bestPracticesMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest deviceBootPerformanceMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("deviceBootPerformanceMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest rebootAnalyticsMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("rebootAnalyticsMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest resourcePerformanceMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("resourcePerformanceMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest workFromAnywhereMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("workFromAnywhereMetrics"), Optional.empty());
    }

}
