package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserAnalytics;
import odata.msgraph.client.beta.entity.collection.request.ActivityStatisticsCollectionRequest;

@JsonIgnoreType
public class UserAnalyticsRequest extends EntityRequest<UserAnalytics> {

    public UserAnalyticsRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserAnalytics.class, contextPath, value, false);
    }

    public ActivityStatisticsRequest activityStatistics(String id) {
        return new ActivityStatisticsRequest(contextPath.addSegment("activityStatistics").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ActivityStatisticsCollectionRequest activityStatistics() {
        return new ActivityStatisticsCollectionRequest(
                        contextPath.addSegment("activityStatistics"), Optional.empty());
    }

}
