package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleEligibilityScheduleRequest;

@JsonIgnoreType
public class UnifiedRoleEligibilityScheduleRequestRequest extends EntityRequest<UnifiedRoleEligibilityScheduleRequest> {

    public UnifiedRoleEligibilityScheduleRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(UnifiedRoleEligibilityScheduleRequest.class, contextPath, value, false);
    }

    public AppScopeRequest appScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"), Optional.empty());
    }

    public DirectoryObjectRequest directoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"), Optional.empty());
    }

    public DirectoryObjectRequest principal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"), Optional.empty());
    }

    public UnifiedRoleDefinitionRequest roleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

    public odata.msgraph.client.beta.entity.request.UnifiedRoleEligibilityScheduleRequest targetSchedule() {
        return new odata.msgraph.client.beta.entity.request.UnifiedRoleEligibilityScheduleRequest(contextPath.addSegment("targetSchedule"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

}
