package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignment;

@JsonIgnoreType
public class UnifiedRoleAssignmentRequest extends EntityRequest<UnifiedRoleAssignment> {

    public UnifiedRoleAssignmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(UnifiedRoleAssignment.class, contextPath, value, false);
    }

    public AppScopeRequest appScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"), Optional.empty());
    }

    public DirectoryObjectRequest directoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"), Optional.empty());
    }

    public DirectoryObjectRequest principal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"), Optional.empty());
    }

    public UnifiedRoleDefinitionRequest roleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

}
