package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignmentMultiple;
import odata.msgraph.client.beta.entity.collection.request.AppScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;

@JsonIgnoreType
public class UnifiedRoleAssignmentMultipleRequest extends EntityRequest<UnifiedRoleAssignmentMultiple> {

    public UnifiedRoleAssignmentMultipleRequest(ContextPath contextPath, Optional<Object> value) {
        super(UnifiedRoleAssignmentMultiple.class, contextPath, value, false);
    }

    public AppScopeRequest appScopes(String id) {
        return new AppScopeRequest(contextPath.addSegment("appScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppScopeCollectionRequest appScopes() {
        return new AppScopeCollectionRequest(
                        contextPath.addSegment("appScopes"), Optional.empty());
    }

    public DirectoryObjectRequest directoryScopes(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest directoryScopes() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directoryScopes"), Optional.empty());
    }

    public DirectoryObjectRequest principals(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("principals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest principals() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("principals"), Optional.empty());
    }

    public UnifiedRoleDefinitionRequest roleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

}
