package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRbacResourceNamespace;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRbacResourceActionCollectionRequest;

@JsonIgnoreType
public class UnifiedRbacResourceNamespaceRequest extends EntityRequest<UnifiedRbacResourceNamespace> {

    public UnifiedRbacResourceNamespaceRequest(ContextPath contextPath, Optional<Object> value) {
        super(UnifiedRbacResourceNamespace.class, contextPath, value, false);
    }

    public UnifiedRbacResourceActionRequest resourceActions(String id) {
        return new UnifiedRbacResourceActionRequest(contextPath.addSegment("resourceActions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRbacResourceActionCollectionRequest resourceActions() {
        return new UnifiedRbacResourceActionCollectionRequest(
                        contextPath.addSegment("resourceActions"), Optional.empty());
    }

    @Action(name = "importResourceActions")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnifiedRbacResourceNamespace> importResourceActions(String format, String value, Boolean overwriteResourceNamespace) {
        Preconditions.checkNotNull(format, "format cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        Preconditions.checkNotNull(overwriteResourceNamespace, "overwriteResourceNamespace cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("format", "Edm.String", Checks.checkIsAscii(format))
            .put("value", "Edm.String", Checks.checkIsAscii(value))
            .put("overwriteResourceNamespace", "Edm.Boolean", overwriteResourceNamespace)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnifiedRbacResourceNamespace>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.importResourceActions"), UnifiedRbacResourceNamespace.class, _parameters);
    }

}
