package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TodoTask;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LinkedResourceCollectionRequest;

@JsonIgnoreType
public class TodoTaskRequest extends EntityRequest<TodoTask> {

    public TodoTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(TodoTask.class, contextPath, value, false);
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public LinkedResourceRequest linkedResources(String id) {
        return new LinkedResourceRequest(contextPath.addSegment("linkedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LinkedResourceCollectionRequest linkedResources() {
        return new LinkedResourceCollectionRequest(
                        contextPath.addSegment("linkedResources"), Optional.empty());
    }

}
