package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TodoTaskList;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TodoTaskCollectionRequest;

@JsonIgnoreType
public class TodoTaskListRequest extends EntityRequest<TodoTaskList> {

    public TodoTaskListRequest(ContextPath contextPath, Optional<Object> value) {
        super(TodoTaskList.class, contextPath, value, false);
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public TodoTaskRequest tasks(String id) {
        return new TodoTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TodoTaskCollectionRequest tasks() {
        return new TodoTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
