package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.entity.TimeCard;

@JsonIgnoreType
public class TimeCardRequest extends EntityRequest<TimeCard> {

    public TimeCardRequest(ContextPath contextPath, Optional<Object> value) {
        super(TimeCard.class, contextPath, value, false);
    }

    @Action(name = "clockOut")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> clockOut(Boolean atApprovedLocation, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clockOut"), TimeCard.class, _parameters);
    }

    @Action(name = "confirm")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> confirm() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.confirm"), TimeCard.class, _parameters);
    }

    @Action(name = "endBreak")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> endBreak(Boolean atApprovedLocation, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.endBreak"), TimeCard.class, _parameters);
    }

    @Action(name = "startBreak")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> startBreak(Boolean atApprovedLocation, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startBreak"), TimeCard.class, _parameters);
    }

}
