package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ThreatAssessmentRequest;
import odata.msgraph.client.beta.entity.collection.request.ThreatAssessmentResultCollectionRequest;

@JsonIgnoreType
public class ThreatAssessmentRequestRequest extends EntityRequest<ThreatAssessmentRequest> {

    public ThreatAssessmentRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(ThreatAssessmentRequest.class, contextPath, value, false);
    }

    public ThreatAssessmentResultRequest results(String id) {
        return new ThreatAssessmentResultRequest(contextPath.addSegment("results").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ThreatAssessmentResultCollectionRequest results() {
        return new ThreatAssessmentResultCollectionRequest(
                        contextPath.addSegment("results"), Optional.empty());
    }

}
