package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TermsAndConditions;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsAcceptanceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsGroupAssignmentCollectionRequest;

@JsonIgnoreType
public class TermsAndConditionsRequest extends EntityRequest<TermsAndConditions> {

    public TermsAndConditionsRequest(ContextPath contextPath, Optional<Object> value) {
        super(TermsAndConditions.class, contextPath, value, false);
    }

    public TermsAndConditionsAcceptanceStatusRequest acceptanceStatuses(String id) {
        return new TermsAndConditionsAcceptanceStatusRequest(contextPath.addSegment("acceptanceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsAcceptanceStatusCollectionRequest acceptanceStatuses() {
        return new TermsAndConditionsAcceptanceStatusCollectionRequest(
                        contextPath.addSegment("acceptanceStatuses"), Optional.empty());
    }

    public TermsAndConditionsAssignmentRequest assignments(String id) {
        return new TermsAndConditionsAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsAssignmentCollectionRequest assignments() {
        return new TermsAndConditionsAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public TermsAndConditionsGroupAssignmentRequest groupAssignments(String id) {
        return new TermsAndConditionsGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsGroupAssignmentCollectionRequest groupAssignments() {
        return new TermsAndConditionsGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"), Optional.empty());
    }

}
