package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TenantRelationship;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminCustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminRelationshipCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagedTenantRequest;

@JsonIgnoreType
public class TenantRelationshipRequest extends EntityRequest<TenantRelationship> {

    public TenantRelationshipRequest(ContextPath contextPath, Optional<Object> value) {
        super(TenantRelationship.class, contextPath, value, false);
    }

    public ManagedTenantRequest managedTenants() {
        return new ManagedTenantRequest(contextPath.addSegment("managedTenants"), Optional.empty());
    }

    public DelegatedAdminCustomerRequest delegatedAdminCustomers(String id) {
        return new DelegatedAdminCustomerRequest(contextPath.addSegment("delegatedAdminCustomers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminCustomerCollectionRequest delegatedAdminCustomers() {
        return new DelegatedAdminCustomerCollectionRequest(
                        contextPath.addSegment("delegatedAdminCustomers"), Optional.empty());
    }

    public DelegatedAdminRelationshipRequest delegatedAdminRelationships(String id) {
        return new DelegatedAdminRelationshipRequest(contextPath.addSegment("delegatedAdminRelationships").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminRelationshipCollectionRequest delegatedAdminRelationships() {
        return new DelegatedAdminRelationshipCollectionRequest(
                        contextPath.addSegment("delegatedAdminRelationships"), Optional.empty());
    }

}
