package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamworkTag;
import odata.msgraph.client.beta.entity.collection.request.TeamworkTagMemberCollectionRequest;

@JsonIgnoreType
public class TeamworkTagRequest extends EntityRequest<TeamworkTag> {

    public TeamworkTagRequest(ContextPath contextPath, Optional<Object> value) {
        super(TeamworkTag.class, contextPath, value, false);
    }

    public TeamworkTagMemberRequest members(String id) {
        return new TeamworkTagMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkTagMemberCollectionRequest members() {
        return new TeamworkTagMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

}
