package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamworkDevice;
import odata.msgraph.client.beta.entity.collection.request.TeamworkDeviceOperationCollectionRequest;
import odata.msgraph.client.beta.enums.TeamworkSoftwareType;

@JsonIgnoreType
public class TeamworkDeviceRequest extends EntityRequest<TeamworkDevice> {

    public TeamworkDeviceRequest(ContextPath contextPath, Optional<Object> value) {
        super(TeamworkDevice.class, contextPath, value, false);
    }

    public TeamworkDeviceActivityRequest activity() {
        return new TeamworkDeviceActivityRequest(contextPath.addSegment("activity"), Optional.empty());
    }

    public TeamworkDeviceConfigurationRequest configuration() {
        return new TeamworkDeviceConfigurationRequest(contextPath.addSegment("configuration"), Optional.empty());
    }

    public TeamworkDeviceHealthRequest health() {
        return new TeamworkDeviceHealthRequest(contextPath.addSegment("health"), Optional.empty());
    }

    public TeamworkDeviceOperationRequest operations(String id) {
        return new TeamworkDeviceOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkDeviceOperationCollectionRequest operations() {
        return new TeamworkDeviceOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    @Action(name = "restart")
    @JsonIgnore
    public ActionRequestNoReturn restart() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restart"), _parameters);
    }

    @Action(name = "runDiagnostics")
    @JsonIgnore
    public ActionRequestNoReturn runDiagnostics() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.runDiagnostics"), _parameters);
    }

    @Action(name = "updateSoftware")
    @JsonIgnore
    public ActionRequestNoReturn updateSoftware(TeamworkSoftwareType softwareType, String softwareVersion) {
        Preconditions.checkNotNull(softwareType, "softwareType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("softwareType", "microsoft.graph.teamworkSoftwareType", softwareType)
            .put("softwareVersion", "Edm.String", Checks.checkIsAscii(softwareVersion))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateSoftware"), _parameters);
    }

}
