package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamsAppInstallation;

@JsonIgnoreType
public class TeamsAppInstallationRequest extends EntityRequest<TeamsAppInstallation> {

    public TeamsAppInstallationRequest(ContextPath contextPath, Optional<Object> value) {
        super(TeamsAppInstallation.class, contextPath, value, false);
    }

    public TeamsAppRequest teamsApp() {
        return new TeamsAppRequest(contextPath.addSegment("teamsApp"), Optional.empty());
    }

    public TeamsAppDefinitionRequest teamsAppDefinition() {
        return new TeamsAppDefinitionRequest(contextPath.addSegment("teamsAppDefinition"), Optional.empty());
    }

    @Action(name = "upgrade")
    @JsonIgnore
    public ActionRequestNoReturn upgrade() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.upgrade"), _parameters);
    }

}
