package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.complex.TeamworkNotificationRecipient;
import odata.msgraph.client.beta.entity.Team;
import odata.msgraph.client.beta.entity.collection.request.ChannelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceSpecificPermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAsyncOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamworkTagCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.enums.ClonableTeamParts;
import odata.msgraph.client.beta.enums.TeamVisibilityType;

@JsonIgnoreType
public class TeamRequest extends EntityRequest<Team> {

    public TeamRequest(ContextPath contextPath, Optional<Object> value) {
        super(Team.class, contextPath, value, false);
    }

    public ChannelRequest channels(String id) {
        return new ChannelRequest(contextPath.addSegment("channels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChannelCollectionRequest channels() {
        return new ChannelCollectionRequest(
                        contextPath.addSegment("channels"), Optional.empty());
    }

    public GroupRequest group() {
        return new GroupRequest(contextPath.addSegment("group"), Optional.empty());
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"), Optional.empty());
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public TeamsAsyncOperationRequest operations(String id) {
        return new TeamsAsyncOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAsyncOperationCollectionRequest operations() {
        return new TeamsAsyncOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public UserRequest owners(String id) {
        return new UserRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCollectionRequest owners() {
        return new UserCollectionRequest(
                        contextPath.addSegment("owners"), Optional.empty());
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ResourceSpecificPermissionGrantCollectionRequest permissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(
                        contextPath.addSegment("permissionGrants"), Optional.empty());
    }

    public ProfilePhotoRequest photo() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.empty());
    }

    public ChannelRequest primaryChannel() {
        return new ChannelRequest(contextPath.addSegment("primaryChannel"), Optional.empty());
    }

    public TeamworkTagRequest tags(String id) {
        return new TeamworkTagRequest(contextPath.addSegment("tags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkTagCollectionRequest tags() {
        return new TeamworkTagCollectionRequest(
                        contextPath.addSegment("tags"), Optional.empty());
    }

    public TeamsTemplateRequest template() {
        return new TeamsTemplateRequest(contextPath.addSegment("template"), Optional.empty());
    }

    public ScheduleRequest schedule() {
        return new ScheduleRequest(contextPath.addSegment("schedule"), Optional.empty());
    }

    @Action(name = "clone")
    @JsonIgnore
    public ActionRequestNoReturn clone(String displayName, String description, String mailNickname, String classification, TeamVisibilityType visibility, ClonableTeamParts partsToClone) {
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
        Preconditions.checkNotNull(partsToClone, "partsToClone cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("mailNickname", "Edm.String", Checks.checkIsAscii(mailNickname))
            .put("classification", "Edm.String", Checks.checkIsAscii(classification))
            .put("visibility", "microsoft.graph.teamVisibilityType", visibility)
            .put("partsToClone", "microsoft.graph.clonableTeamParts", partsToClone)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clone"), _parameters);
    }

    @Action(name = "archive")
    @JsonIgnore
    public ActionRequestNoReturn archive(Boolean shouldSetSpoSiteReadOnlyForMembers) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shouldSetSpoSiteReadOnlyForMembers", "Edm.Boolean", shouldSetSpoSiteReadOnlyForMembers)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.archive"), _parameters);
    }

    @Action(name = "unarchive")
    @JsonIgnore
    public ActionRequestNoReturn unarchive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unarchive"), _parameters);
    }

    @Action(name = "completeMigration")
    @JsonIgnore
    public ActionRequestNoReturn completeMigration() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeMigration"), _parameters);
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters, TeamworkNotificationRecipient recipient) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .put("recipient", "microsoft.graph.teamworkNotificationRecipient", recipient)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

}
