package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Tasks;
import odata.msgraph.client.beta.entity.collection.request.BaseTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BaseTaskListCollectionRequest;

@JsonIgnoreType
public class TasksRequest extends EntityRequest<Tasks> {

    public TasksRequest(ContextPath contextPath, Optional<Object> value) {
        super(Tasks.class, contextPath, value, false);
    }

    public BaseTaskRequest alltasks(String id) {
        return new BaseTaskRequest(contextPath.addSegment("alltasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BaseTaskCollectionRequest alltasks() {
        return new BaseTaskCollectionRequest(
                        contextPath.addSegment("alltasks"), Optional.empty());
    }

    public BaseTaskListRequest lists(String id) {
        return new BaseTaskListRequest(contextPath.addSegment("lists").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BaseTaskListCollectionRequest lists() {
        return new BaseTaskListCollectionRequest(
                        contextPath.addSegment("lists"), Optional.empty());
    }

}
