package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedMobileApp;
import odata.msgraph.client.beta.entity.TargetedManagedAppConfiguration;
import odata.msgraph.client.beta.entity.TargetedManagedAppPolicyAssignment;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.enums.TargetedManagedAppGroupType;

@JsonIgnoreType
public class TargetedManagedAppConfigurationRequest extends EntityRequest<TargetedManagedAppConfiguration> {

    public TargetedManagedAppConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(TargetedManagedAppConfiguration.class, contextPath, value, false);
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"), Optional.empty());
    }

    public TargetedManagedAppPolicyAssignmentRequest assignments(String id) {
        return new TargetedManagedAppPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TargetedManagedAppPolicyAssignmentCollectionRequest assignments() {
        return new TargetedManagedAppPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public ManagedAppPolicyDeploymentSummaryRequest deploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<TargetedManagedAppPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.targetedManagedAppPolicyAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "targetApps")
    @JsonIgnore
    public ActionRequestNoReturn targetApps(List<ManagedMobileApp> apps, TargetedManagedAppGroupType appGroupType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("apps", "Collection(microsoft.graph.managedMobileApp)", apps)
            .put("appGroupType", "microsoft.graph.targetedManagedAppGroupType", appGroupType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.targetApps"), _parameters);
    }

}
