package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SubjectRightsRequest;
import odata.msgraph.client.beta.entity.collection.request.AuthoredNoteCollectionRequest;

@JsonIgnoreType
public class SubjectRightsRequestRequest extends EntityRequest<SubjectRightsRequest> {

    public SubjectRightsRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(SubjectRightsRequest.class, contextPath, value, false);
    }

    public AuthoredNoteRequest notes(String id) {
        return new AuthoredNoteRequest(contextPath.addSegment("notes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthoredNoteCollectionRequest notes() {
        return new AuthoredNoteCollectionRequest(
                        contextPath.addSegment("notes"), Optional.empty());
    }

    public TeamRequest team() {
        return new TeamRequest(contextPath.addSegment("team"), Optional.empty());
    }

    @Function(name = "getFinalAttachment")
    @JsonIgnore
    public FunctionRequestReturningStream getFinalAttachment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFinalAttachment"), _parameters);
    }

    @Function(name = "getFinalReport")
    @JsonIgnore
    public FunctionRequestReturningStream getFinalReport() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFinalReport"), _parameters);
    }

}
