package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SimulationAutomation;
import odata.msgraph.client.beta.entity.collection.request.SimulationAutomationRunCollectionRequest;

@JsonIgnoreType
public class SimulationAutomationRequest extends EntityRequest<SimulationAutomation> {

    public SimulationAutomationRequest(ContextPath contextPath, Optional<Object> value) {
        super(SimulationAutomation.class, contextPath, value, false);
    }

    public SimulationAutomationRunRequest runs(String id) {
        return new SimulationAutomationRunRequest(contextPath.addSegment("runs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SimulationAutomationRunCollectionRequest runs() {
        return new SimulationAutomationRunCollectionRequest(
                        contextPath.addSegment("runs"), Optional.empty());
    }

}
