package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SharedDriveItem;
import odata.msgraph.client.beta.entity.collection.request.DriveItemCollectionRequest;

@JsonIgnoreType
public class SharedDriveItemRequest extends EntityRequest<SharedDriveItem> {

    public SharedDriveItemRequest(ContextPath contextPath, Optional<Object> value) {
        super(SharedDriveItem.class, contextPath, value, false);
    }

    public DriveItemRequest driveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"), Optional.empty());
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.empty());
    }

    public ListRequest list() {
        return new ListRequest(contextPath.addSegment("list"), Optional.empty());
    }

    public ListItemRequest listItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"), Optional.empty());
    }

    public PermissionRequest permission() {
        return new PermissionRequest(contextPath.addSegment("permission"), Optional.empty());
    }

    public DriveItemRequest root() {
        return new DriveItemRequest(contextPath.addSegment("root"), Optional.empty());
    }

    public SiteRequest site() {
        return new SiteRequest(contextPath.addSegment("site"), Optional.empty());
    }

}
