package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Credential;
import odata.msgraph.client.beta.complex.PasswordSingleSignOnCredentialSet;
import odata.msgraph.client.beta.complex.SelfSignedCertificate;
import odata.msgraph.client.beta.entity.ServicePrincipal;
import odata.msgraph.client.beta.entity.collection.request.AppManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedPermissionClassificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EndpointCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FederatedIdentityCredentialCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OAuth2PermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;

@JsonIgnoreType
public class ServicePrincipalRequest extends EntityRequest<ServicePrincipal> {

    public ServicePrincipalRequest(ContextPath contextPath, Optional<Object> value) {
        super(ServicePrincipal.class, contextPath, value, false);
    }

    public AppManagementPolicyRequest appManagementPolicies(String id) {
        return new AppManagementPolicyRequest(contextPath.addSegment("appManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppManagementPolicyCollectionRequest appManagementPolicies() {
        return new AppManagementPolicyCollectionRequest(
                        contextPath.addSegment("appManagementPolicies"), Optional.empty());
    }

    public AppRoleAssignmentRequest appRoleAssignedTo(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignedTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignedTo() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignedTo"), Optional.empty());
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"), Optional.empty());
    }

    public ClaimsMappingPolicyRequest claimsMappingPolicies(String id) {
        return new ClaimsMappingPolicyRequest(contextPath.addSegment("claimsMappingPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ClaimsMappingPolicyCollectionRequest claimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"), Optional.empty());
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"), Optional.empty());
    }

    public DelegatedPermissionClassificationRequest delegatedPermissionClassifications(String id) {
        return new DelegatedPermissionClassificationRequest(contextPath.addSegment("delegatedPermissionClassifications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedPermissionClassificationCollectionRequest delegatedPermissionClassifications() {
        return new DelegatedPermissionClassificationCollectionRequest(
                        contextPath.addSegment("delegatedPermissionClassifications"), Optional.empty());
    }

    public EndpointRequest endpoints(String id) {
        return new EndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EndpointCollectionRequest endpoints() {
        return new EndpointCollectionRequest(
                        contextPath.addSegment("endpoints"), Optional.empty());
    }

    public FederatedIdentityCredentialRequest federatedIdentityCredentials(String id) {
        return new FederatedIdentityCredentialRequest(contextPath.addSegment("federatedIdentityCredentials").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FederatedIdentityCredentialCollectionRequest federatedIdentityCredentials() {
        return new FederatedIdentityCredentialCollectionRequest(
                        contextPath.addSegment("federatedIdentityCredentials"), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"), Optional.empty());
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), Optional.empty());
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OAuth2PermissionGrantCollectionRequest oauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(
                        contextPath.addSegment("oauth2PermissionGrants"), Optional.empty());
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"), Optional.empty());
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"), Optional.empty());
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"), Optional.empty());
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public SynchronizationRequest synchronization() {
        return new SynchronizationRequest(contextPath.addSegment("synchronization"), Optional.empty());
    }

    @Action(name = "createPasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet> createPasswordSingleSignOnCredentials(String id, List<Credential> credentials) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(credentials, "credentials cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("credentials", "Collection(microsoft.graph.credential)", credentials)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createPasswordSingleSignOnCredentials"), PasswordSingleSignOnCredentialSet.class, _parameters);
    }

    @Action(name = "deletePasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestNoReturn deletePasswordSingleSignOnCredentials(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deletePasswordSingleSignOnCredentials"), _parameters);
    }

    @Action(name = "getPasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet> getPasswordSingleSignOnCredentials(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPasswordSingleSignOnCredentials"), PasswordSingleSignOnCredentialSet.class, _parameters);
    }

    @Action(name = "updatePasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestNoReturn updatePasswordSingleSignOnCredentials(String id, List<Credential> credentials) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(credentials, "credentials cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("credentials", "Collection(microsoft.graph.credential)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updatePasswordSingleSignOnCredentials"), _parameters);
    }

    @Action(name = "addTokenSigningCertificate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SelfSignedCertificate> addTokenSigningCertificate(String displayName, OffsetDateTime endDateTime) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SelfSignedCertificate>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addTokenSigningCertificate"), SelfSignedCertificate.class, _parameters);
    }

}
