package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServicePrincipalCreationPolicy;
import odata.msgraph.client.beta.entity.collection.request.ServicePrincipalCreationConditionSetCollectionRequest;

@JsonIgnoreType
public class ServicePrincipalCreationPolicyRequest extends EntityRequest<ServicePrincipalCreationPolicy> {

    public ServicePrincipalCreationPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(ServicePrincipalCreationPolicy.class, contextPath, value, false);
    }

    public ServicePrincipalCreationConditionSetRequest excludes(String id) {
        return new ServicePrincipalCreationConditionSetRequest(contextPath.addSegment("excludes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipalCreationConditionSetCollectionRequest excludes() {
        return new ServicePrincipalCreationConditionSetCollectionRequest(
                        contextPath.addSegment("excludes"), Optional.empty());
    }

    public ServicePrincipalCreationConditionSetRequest includes(String id) {
        return new ServicePrincipalCreationConditionSetRequest(contextPath.addSegment("includes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipalCreationConditionSetCollectionRequest includes() {
        return new ServicePrincipalCreationConditionSetCollectionRequest(
                        contextPath.addSegment("includes"), Optional.empty());
    }

}
