package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SensitivityLabel;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;

@JsonIgnoreType
public class SensitivityLabelRequest extends EntityRequest<SensitivityLabel> {

    public SensitivityLabelRequest(ContextPath contextPath, Optional<Object> value) {
        super(SensitivityLabel.class, contextPath, value, false);
    }

    public SensitivityLabelRequest sublabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sublabels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SensitivityLabelCollectionRequest sublabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sublabels"), Optional.empty());
    }

}
