package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SecurityConfigurationTask;
import odata.msgraph.client.beta.entity.collection.request.VulnerableManagedDeviceCollectionRequest;

@JsonIgnoreType
public class SecurityConfigurationTaskRequest extends EntityRequest<SecurityConfigurationTask> {

    public SecurityConfigurationTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(SecurityConfigurationTask.class, contextPath, value, false);
    }

    public VulnerableManagedDeviceRequest managedDevices(String id) {
        return new VulnerableManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public VulnerableManagedDeviceCollectionRequest managedDevices() {
        return new VulnerableManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.empty());
    }

}
