package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SecurityBaselineTemplate;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineCategoryStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineDeviceStateCollectionRequest;

@JsonIgnoreType
public class SecurityBaselineTemplateRequest extends EntityRequest<SecurityBaselineTemplate> {

    public SecurityBaselineTemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(SecurityBaselineTemplate.class, contextPath, value, false);
    }

    public SecurityBaselineCategoryStateSummaryRequest categoryDeviceStateSummaries(String id) {
        return new SecurityBaselineCategoryStateSummaryRequest(contextPath.addSegment("categoryDeviceStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecurityBaselineCategoryStateSummaryCollectionRequest categoryDeviceStateSummaries() {
        return new SecurityBaselineCategoryStateSummaryCollectionRequest(
                        contextPath.addSegment("categoryDeviceStateSummaries"), Optional.empty());
    }

    public SecurityBaselineDeviceStateRequest deviceStates(String id) {
        return new SecurityBaselineDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecurityBaselineDeviceStateCollectionRequest deviceStates() {
        return new SecurityBaselineDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.empty());
    }

    public SecurityBaselineStateSummaryRequest deviceStateSummary() {
        return new SecurityBaselineStateSummaryRequest(contextPath.addSegment("deviceStateSummary"), Optional.empty());
    }

}
