package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import microsoft.graph.search.collection.request.AcronymCollectionRequest;
import microsoft.graph.search.collection.request.BookmarkCollectionRequest;
import microsoft.graph.search.collection.request.QnaCollectionRequest;
import microsoft.graph.search.entity.request.AcronymEntityRequest;
import microsoft.graph.search.entity.request.BookmarkEntityRequest;
import microsoft.graph.search.entity.request.QnaEntityRequest;

import odata.msgraph.client.beta.complex.SearchRequest;
import odata.msgraph.client.beta.complex.SearchResponse;
import odata.msgraph.client.beta.entity.SearchEntity;

@JsonIgnoreType
public class SearchEntityRequest extends EntityRequest<SearchEntity> {

    public SearchEntityRequest(ContextPath contextPath, Optional<Object> value) {
        super(SearchEntity.class, contextPath, value, false);
    }

    public AcronymEntityRequest acronyms(String id) {
        return new AcronymEntityRequest(contextPath.addSegment("acronyms").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AcronymCollectionRequest acronyms() {
        return new AcronymCollectionRequest(
                        contextPath.addSegment("acronyms"), Optional.empty());
    }

    public BookmarkEntityRequest bookmarks(String id) {
        return new BookmarkEntityRequest(contextPath.addSegment("bookmarks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BookmarkCollectionRequest bookmarks() {
        return new BookmarkCollectionRequest(
                        contextPath.addSegment("bookmarks"), Optional.empty());
    }

    public QnaEntityRequest qnas(String id) {
        return new QnaEntityRequest(contextPath.addSegment("qnas").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public QnaCollectionRequest qnas() {
        return new QnaCollectionRequest(
                        contextPath.addSegment("qnas"), Optional.empty());
    }

    @Action(name = "query")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SearchResponse> query(List<SearchRequest> requests) {
        Preconditions.checkNotNull(requests, "requests cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("requests", "Collection(microsoft.graph.searchRequest)", requests)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.query"), SearchResponse.class, _parameters);
    }

}
