package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Schedule;
import odata.msgraph.client.beta.entity.collection.request.OfferShiftRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OpenShiftChangeRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OpenShiftCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SchedulingGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ShiftCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SwapShiftsChangeRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeCardCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffReasonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffRequestCollectionRequest;

@JsonIgnoreType
public class ScheduleRequest extends EntityRequest<Schedule> {

    public ScheduleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Schedule.class, contextPath, value, false);
    }

    public OfferShiftRequestRequest offerShiftRequests(String id) {
        return new OfferShiftRequestRequest(contextPath.addSegment("offerShiftRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OfferShiftRequestCollectionRequest offerShiftRequests() {
        return new OfferShiftRequestCollectionRequest(
                        contextPath.addSegment("offerShiftRequests"), Optional.empty());
    }

    public OpenShiftChangeRequestRequest openShiftChangeRequests(String id) {
        return new OpenShiftChangeRequestRequest(contextPath.addSegment("openShiftChangeRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OpenShiftChangeRequestCollectionRequest openShiftChangeRequests() {
        return new OpenShiftChangeRequestCollectionRequest(
                        contextPath.addSegment("openShiftChangeRequests"), Optional.empty());
    }

    public OpenShiftRequest openShifts(String id) {
        return new OpenShiftRequest(contextPath.addSegment("openShifts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OpenShiftCollectionRequest openShifts() {
        return new OpenShiftCollectionRequest(
                        contextPath.addSegment("openShifts"), Optional.empty());
    }

    public SchedulingGroupRequest schedulingGroups(String id) {
        return new SchedulingGroupRequest(contextPath.addSegment("schedulingGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SchedulingGroupCollectionRequest schedulingGroups() {
        return new SchedulingGroupCollectionRequest(
                        contextPath.addSegment("schedulingGroups"), Optional.empty());
    }

    public ShiftRequest shifts(String id) {
        return new ShiftRequest(contextPath.addSegment("shifts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ShiftCollectionRequest shifts() {
        return new ShiftCollectionRequest(
                        contextPath.addSegment("shifts"), Optional.empty());
    }

    public SwapShiftsChangeRequestRequest swapShiftsChangeRequests(String id) {
        return new SwapShiftsChangeRequestRequest(contextPath.addSegment("swapShiftsChangeRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SwapShiftsChangeRequestCollectionRequest swapShiftsChangeRequests() {
        return new SwapShiftsChangeRequestCollectionRequest(
                        contextPath.addSegment("swapShiftsChangeRequests"), Optional.empty());
    }

    public TimeCardRequest timeCards(String id) {
        return new TimeCardRequest(contextPath.addSegment("timeCards").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TimeCardCollectionRequest timeCards() {
        return new TimeCardCollectionRequest(
                        contextPath.addSegment("timeCards"), Optional.empty());
    }

    public TimeOffReasonRequest timeOffReasons(String id) {
        return new TimeOffReasonRequest(contextPath.addSegment("timeOffReasons").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TimeOffReasonCollectionRequest timeOffReasons() {
        return new TimeOffReasonCollectionRequest(
                        contextPath.addSegment("timeOffReasons"), Optional.empty());
    }

    public TimeOffRequestRequest timeOffRequests(String id) {
        return new TimeOffRequestRequest(contextPath.addSegment("timeOffRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TimeOffRequestCollectionRequest timeOffRequests() {
        return new TimeOffRequestCollectionRequest(
                        contextPath.addSegment("timeOffRequests"), Optional.empty());
    }

    public TimeOffRequest timesOff(String id) {
        return new TimeOffRequest(contextPath.addSegment("timesOff").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TimeOffCollectionRequest timesOff() {
        return new TimeOffCollectionRequest(
                        contextPath.addSegment("timesOff"), Optional.empty());
    }

    @Action(name = "share")
    @JsonIgnore
    public ActionRequestNoReturn share(Boolean notifyTeam, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyTeam", "Edm.Boolean", notifyTeam)
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.share"), _parameters);
    }

}
