package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesQuote;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteLineCollectionRequest;

@JsonIgnoreType
public class SalesQuoteRequest extends EntityRequest<SalesQuote> {

    public SalesQuoteRequest(ContextPath contextPath, Optional<Object> value) {
        super(SalesQuote.class, contextPath, value, false);
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.empty());
    }

    public CustomerRequest customer() {
        return new CustomerRequest(contextPath.addSegment("customer"), Optional.empty());
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.empty());
    }

    public SalesQuoteLineRequest salesQuoteLines(String id) {
        return new SalesQuoteLineRequest(contextPath.addSegment("salesQuoteLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesQuoteLineCollectionRequest salesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(
                        contextPath.addSegment("salesQuoteLines"), Optional.empty());
    }

    public ShipmentMethodRequest shipmentMethod() {
        return new ShipmentMethodRequest(contextPath.addSegment("shipmentMethod"), Optional.empty());
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

    @Action(name = "makeInvoice")
    @JsonIgnore
    public ActionRequestNoReturn makeInvoice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.makeInvoice"), _parameters);
    }

}
