package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesInvoice;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceLineCollectionRequest;

@JsonIgnoreType
public class SalesInvoiceRequest extends EntityRequest<SalesInvoice> {

    public SalesInvoiceRequest(ContextPath contextPath, Optional<Object> value) {
        super(SalesInvoice.class, contextPath, value, false);
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.empty());
    }

    public CustomerRequest customer() {
        return new CustomerRequest(contextPath.addSegment("customer"), Optional.empty());
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.empty());
    }

    public SalesInvoiceLineRequest salesInvoiceLines(String id) {
        return new SalesInvoiceLineRequest(contextPath.addSegment("salesInvoiceLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesInvoiceLineCollectionRequest salesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(
                        contextPath.addSegment("salesInvoiceLines"), Optional.empty());
    }

    public ShipmentMethodRequest shipmentMethod() {
        return new ShipmentMethodRequest(contextPath.addSegment("shipmentMethod"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

    @Action(name = "cancelAndSend")
    @JsonIgnore
    public ActionRequestNoReturn cancelAndSend() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelAndSend"), _parameters);
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

    @Action(name = "postAndSend")
    @JsonIgnore
    public ActionRequestNoReturn postAndSend() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postAndSend"), _parameters);
    }

}
