package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesCreditMemo;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoLineCollectionRequest;

@JsonIgnoreType
public class SalesCreditMemoRequest extends EntityRequest<SalesCreditMemo> {

    public SalesCreditMemoRequest(ContextPath contextPath, Optional<Object> value) {
        super(SalesCreditMemo.class, contextPath, value, false);
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.empty());
    }

    public CustomerRequest customer() {
        return new CustomerRequest(contextPath.addSegment("customer"), Optional.empty());
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.empty());
    }

    public SalesCreditMemoLineRequest salesCreditMemoLines(String id) {
        return new SalesCreditMemoLineRequest(contextPath.addSegment("salesCreditMemoLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesCreditMemoLineCollectionRequest salesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(
                        contextPath.addSegment("salesCreditMemoLines"), Optional.empty());
    }

}
